#pragma rtGlobals=1		// Use modern global access method.

#pragma ModuleName = SNSLR
Menu "Plot&Fit"

	Submenu "Reflectivity Tools"
		"Reflectivity Panel/0",DWS_ReflManipulationPnl()
		"Thickness from Dq", Tfromdeltaq()
		"Parratt Export Panel",Parratt_Export_Panel()
		"Parratt Import",Parratt_Import()
	End
End

Function Parratt_Import() 
	IN2G_CheckScreenSize("height",670)
	IR2R_ReflectivitySimpleToolMain()
	DoWindow ParrattImportPnl
	if(V_Flag)
		DoWindow/K ParrattImportPnl
	endif
	//IR1D_InitDataManipulation()
	//IR1P_InitializeGenGraph()
	If(!datafolderexists (" root:Packages:ReflectivityTool"))
		Newdatafolder root:Packages:ReflectivityTool
	endif	
	dowindow/K ParrattImportPnl
	NewPanel/K=1 /N=ParrattImportPnl /W=(10,10,500,120 ) 
	TitleBox  title anchor= MT,  fColor=(0,0,65534 ), font="arial", fsize=18, fstyle=0, Title="Parratt Importer",Labelback=0, POS={200,3},Size={200,20}
	Button LoadParratt,pos={0,80},size={120,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Import Parratt Parameters"		
	//following makes use of Irena code to set up the wave dropdown menu
	String PckgDataFolder="ReflectivityTool"
	String PanelWindowName="ParrattImportPnl"
	String AllowedIrenaTypes=""//"DSM_Int;SMR_Int;"
	String AllowedResultsTypes=""//"SizesNumberDistribution;SizesVolumeDistribution;"
	String AllowedUserTypes="*_par;"// "r*;"	
	String UserNameString="_par only" //"qrs"
	String XUserTypeLookup="*_par:*_par;" //"r*:q*;"	"YwaveNameKey:XwaveNameKey;" 
	String EUserTypeLookup=""//"s*;"
	variable RequireErrorWaves=0
	variable  AllowModelData=0	
	IR2C_AddDataControls(PckgDataFolder,PanelWindowName,AllowedIrenaTypes, AllowedResultsTypes, AllowedUserTypes, UserNameString, XUserTypeLookup,EUserTypeLookup, RequireErrorWaves,AllowModelData)
	//Now I clean up Ilavsky's generic dropdowns
	MoveSelectionTools(2, 2)
	CheckBox UseUserDefinedData pos={33,8}
	CheckBox UseQRSData disable=1
	PopupMenu ErrorDataName disable=1
	PopupMenu IntensityDataName  disable=1
end

Function ImportParrattParameters()
	SVAR ParameterWaveName=root:Packages:ReflectivityTool:IntensityWaveName//picks the wave chosen in the Parratt import panel
	wave/T PW=$ParameterWaveName  //access parameter wave as text wave
	//SVAR ActiveDataFolder=root:Packages:ReflectivityTool:DataFolderName
	setdatafolder root:Packages:Refl_SimpleTool	//move to Jans folder to avoid entry of the path for every parameter
	CheckBox L1AtTheBottom  win=IR2R_ReflSimpleToolMainPanel, value=0//uncheck the box in Simple reflectivity tool Panel since Parratt puts layer 1 at the top (I think)
	//now start loading up the panel
	NVAR ThicknessLayer1
	NVAR SLD_Real_Layer1
	NVAR SLD_Imag_Layer1	
	ThicknessLayer1=str2num(PW[17])
	SLD_Real_Layer1=str2num(PW[18])*1e6
	SLD_Imag_Layer1=str2num(PW[19])*1e6

end


Function DWS_ReflManipulationPnl()
	IN2G_CheckScreenSize("height",670)
	DoWindow/R DWS_ReflManipulationPanl	
	IR1D_InitDataManipulation()
	IR1P_InitializeGenGraph()
	If(!datafolderexists (" root:Packages:ReflectivityTool"))
		Newdatafolder root:Packages:ReflectivityTool
	endif
	
	variable/g root:Packages:ReflectivityTool:ReflLambda=1.544,root:Packages:ReflectivityTool:THshift, root:Packages:ReflectivityTool:GraphLogY=1
	variable/g root:Packages:ReflectivityTool:csravg=1,root:Packages:ReflectivityTool:GraphLogX=0,root:Packages:ReflectivityTool:SLDPro=0
	variable/g root:Packages:ReflectivityTool:ErrorMultiplier=0.0002, root:Packages:ReflectivityTool:numcols,root:Packages:ReflectivityTool:ext
	NVAR qshift=root:Packages:ReflectivityTool:qshift
	qshift=0
	make/o/N=2 xavedata,yavedata
	xavedata={ .02, .15}
	yavedata={ 1, .01}
	PlotReflData("yavedata","xavedata", "")
	setAxis bottom .02, .1
	SetAxis/A left

	removefromgraph yavedata
	textBox/K/N=text0
end



Function PlotReflData(rwavename,qwavename, text)
	string rwavename,qwavename, text
	wave rwave=$rwavename
	wave qwave=$qwavename			
	dowindow/K ReflGraph
	Display/K=1/N=ReflGraph/W=(1.1*IN2G_ScreenWidthHeight("width"),1*IN2G_ScreenWidthHeight("heigth"),37*IN2G_ScreenWidthHeight("width"),60*IN2G_ScreenWidthHeight("height")) rwave vs qwave
	ControlBar /T 200
	TitleBox  title anchor= MT,  fColor=(0,0,65534 ), font="arial", fsize=18, fstyle=0, Title="Reflectivity Tool",Labelback=0, POS={200,5},Size={200,20}	
	variable YPOS=130
	Button PlotReflData,pos={0,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="PlotDATA"		
	Button PlotvsAngle,pos={60,YPOS},size={80,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Plot vs TH"	
  	Button RemoveReflTrace,pos={140,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="RemoveTrace"	
  	Button generrors,pos={380,6},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="GenErrors"
  	Button qrs2moto,pos={380,40},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="qrs2Moto"	
  	Button Moto2qrsw,pos={380,60},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Moto2qrsw"	
  	Button sqsw,pos={380,80},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="(s,w)^2"//squares s and w waves
	 Button FootPrintCorrect,pos={400,100},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="F print cor"
  
  	SetVariable ErrorMult, pos={380,23}, size={100,20},title="Multiplier", proc=DWS_ReflSetVariableControl
	SetVariable ErrorMult, limits={-inf,Inf,0.0001},value= root:Packages:ReflectivityTool:ErrorMultiplier

	CheckBox GraphLogY pos={325,YPOS},title="Log Y?", variable= root:Packages:ReflectivityTool:GraphLogY, proc=DWS_GenPlotCheckBox
	CheckBox GraphLogX pos={325,YPOS-15},title="Log X?", variable= root:Packages:ReflectivityTool:GraphLogX, proc=DWS_GenPlotCheckBox
	CheckBox GraphErrors pos={325,YPOS-30},title="Error bars?", variable=root:Packages:GeneralplottingTool:GraphErrors
	CheckBox GraphErrors proc=DWS_GenPlotCheckBox
	CheckBox SLDProfile pos={400,YPOS-30},title="SLD Profile?", variable=root:Packages:ReflectivityTool:SLDPro
	Button FlipProfile,pos={400,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Flip Profile"	
	
	
	Button LoadUDF,pos={200,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Load .udf"	
	Button Loadxrdml,pos={260,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Load .xrdml"		
	//Button LoadASC,pos={270,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Load .asc"	
	YPOS=150	
	Button Normalize,pos={0,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Normalize"	
	//Button toq,pos={60,YPOS},size={50,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Conv to q"	//converts angle to q.  Normally not needed
	//Button rigaku,pos={110,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Load .dat"	
	//Button rigakuASC,pos={170,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Load .asc"	
	//Button Parratt,pos={230,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Parratt"
	
	PopupMenu NumCols title="Columns",pos={118,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflPopupProc;DelayUpdate
	PopupMenu NumCols value="--;1;2;3;4;5;";DelayUpdate
	PopupMenu NumCols help={"Select number of columns for import"}
	
	PopupMenu Ext title="Ext",pos={200,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflPopupProc;DelayUpdate
	PopupMenu Ext value="---;.txt;.fit;.dat;";DelayUpdate
	
	Button Loadcols,pos={300,YPOS},size={70,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Load X Cols"
	Button ChangeMotoNames,pos={370,YPOS},size={90,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Moto Names"
	
	
	
	YPOS=170//shifting is used only for Byoengdu Lee APS data
	Button ShiftTh,pos={0,YPOS},size={45,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Sift TH"			
	SetVariable Thshift, pos={50,YPOS}, size={100,20},title="TH Shift ", proc=DWS_ReflSetVariableControl
	SetVariable Thshift, limits={-inf,Inf,0.001},value= root:Packages:ReflectivityTool:THshift
	SetVariable ReflLambda, pos={150,YPOS}, size={110,20},title="Lambda ()", proc=DWS_setvarDataManip
	SetVariable ReflLambda, value= root:Packages:ReflectivityTool:ReflLambda
	Button RevertShift,pos={260,YPOS},size={50,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Revert"
	Button Format,pos={310,YPOS},size={60,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Color"		
	Button FootPrintCorrect,pos={372,YPOS},size={80,16},font="Times New Roman",fSize=10,proc=DWS_ReflButtonProc,title="Foot print cor"
		
	setdatafolder root:Packages:ReflectivityTool
	String PckgDataFolder="ReflectivityTool"
	String PanelWindowName="ReflGraph"
	String AllowedIrenaTypes=""//"DSM_Int;SMR_Int;"
	String AllowedResultsTypes="SLDPROFILE;"//"SizesNumberDistribution;SizesVolumeDistribution;"
	String AllowedUserTypes=""//"SLDPROFILE*;"//"*_par;" or "r*;"	
	String UserNameString="Profile"//"_par" or "qrs"
	String XUserTypeLookup=""//"r*:q*;"	
	String EUserTypeLookup=""//"s*;"
	variable RequireErrorWaves=0
	variable  AllowModelData=0
	
	IR2C_AddDataControls(PckgDataFolder,PanelWindowName,AllowedIrenaTypes, AllowedResultsTypes, AllowedUserTypes, UserNameString, XUserTypeLookup,EUserTypeLookup, RequireErrorWaves,AllowModelData)	
	MoveSelectionTools(2, 2)
	CheckBox UseResults, pos={80, 0},value=0  
	//CheckBox UseQRSData ,value=1,pos={0, 0},value=0  
end


Function  DWS_ReflSetVariableControl(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName
	IF(cmpstr(ctrlName,"Thshift")==0)//assumes x-scale is Th
		ShiftAngle()
	endif
	IF(cmpstr(ctrlName,"ErrorMult")==0)
		DWS_Refl_Error_Gen()
	endif

end
	
Function ShiftAngle()
		SVAR RWaveName=root:Packages:ReflectivityTool:IntensityWaveName
		SVAR QWaveName=root:Packages:ReflectivityTool:QWavename
		wave RWave=$Rwavename	
		wave QWave=$Qwavename	
		NVAR lambda=root:Packages:ReflectivityTool:refllambda
		string Savename=qwavename+"_org"
		wave savewave=$savename
		If(waveexists (savewave))
			qwave=savewave//first revert
			variable start = (180/pi)*asin(qwave[0]*Lambda/(4*pi))	
			variable step = ((180/pi)*asin(qwave[1]*Lambda/(4*pi)))-start
			SetScale/P x start,step,"", rwave;DelayUpdate
		endif
		//then shift
		NVAR Thshift=root:Packages:ReflectivityTool:ThShift
		 duplicate/o $qwavename, qangle
		 qangle=(180/pi)*asin(qwave*Lambda/(4*pi))
			qangle=qangle+ThShift
	 	string newname=qwavename+"_org"
		if (!waveexists($newname))
			Duplicate/o qwave, $newname
		endif
		qwave=(4*pi/1.5444)*sin(qangle*pi/180)
	 	Note/K qwave, "Thshift= "+num2str(Thshift)+";"
		SetScale/P x qangle[0],qangle[1]-qangle[0],"", rwave;DelayUpdate
	 End

Function NormalizeReflectivity(rwavename)
		string rwavename
		wave rwave=$rwavename
		 WaveStats/Q/R=(.1, 1)  $rwavename
		rwave/=V_max
end

function Tfromdeltaq()
		showinfo
		string rwave= CsrWave(A)
		string folderpath =getwavesDataFolder(TraceNameToWaveRef("", rwave),1)
		setdatafolder folderpath
		string xwave=XWaveName("", rwave )
		wave x=$xwave
		variable dq=x[pcsr(b)]-x[pcsr(a)]///was xcrs
		//print x[pcsr(b)]
		//print x[pcsr(a)]
		//print dq
		string text ="T"+rwave[0,10]+num2str(pcsr(A))  //generate a unique tag name
		text =CleanupName(text, 0 )		
		String words=rwave+": Thickness = "+num2str( 2*pi/dq)+""// at "+num2str(x[xcsr(b)])
		Tag/C/N=$text $rwave, pcsr(A),words
end

function Parratt_Export_Panel()
	IR2E_UniversalDataExport()

	Button LoadAndGraphData,font="Times New Roman",fSize=10,proc=DWSE_InputPanelButtonProc,title="Load and Graph Parratt"
	Button ExportData, proc=DWSE_InputPanelButtonProc,title="Export for Parratt"
	CheckBox AttachWaveNote,disable=1
	SetDrawEnv fname= "Times New Roman",fsize= 22,fstyle= 3,textrgb= (0,0,52224)
	                                                            
	DrawText 10,365,"  Parratt data export      "
End

function DWS_Refl_Error_Gen()
		SVAR FolderName=root:Packages:ReflectivityTool:DataFolderName
		setdatafolder Foldername
		SVAR RWaveName=root:Packages:ReflectivityTool:IntensityWaveName
		wave rwave=$rwavename
		string swavename="s"+rwavename[1,100]
		Duplicate/o rwave, $Swavename
		NVAR mult= root:Packages:ReflectivityTool:ErrorMultiplier
		IN2G_GenerateSASErrors($Rwavename,$Swavename,4,.06, .01,Mult,3)// second to last is most important
			//(IntWave,ErrWave,                                   Pts_avg,Pts_avg_multiplier, IntMultiplier,MultiplySqrt,Smooth_Points)
				//this function will generate some kind of SAXS errors using many differnt methods... 
				// formula E = IntMultiplier * R + MultiplySqrt * sqrt(R)
				// E += Pts_avg_multiplier * abs(smooth(R over Pts_avg) - R)
				// min number of poitns is 3
			DWS_AttachErrorBars(1)
end

Function DWSE_InputPanelButtonProc(ctrlName) : ButtonControl///Parrett export panel bttons
	String ctrlName
	string oldDf=GetDataFolder(1)
	SVAR rwavename=root:Packages:IR2_UniversalDataExport:IntensityWaveName
	SVAR Path=root:Packages:IR2_UniversalDataExport:DataFolderName
	setdatafolder path
	SVAR NewFileOutputName=root:Packages:IR2_UniversalDataExport:NewFileOutputName
	SVAR basename

	if(cmpstr(ctrlName,"LoadAndGraphData")==0)
		IR2E_LoadDataInTool()
		if (exists("basename")==2)
			NewFileOutputName=basename
		else
			NewFileOutputName="Export"
		endif
	endif
	if(cmpstr(ctrlName,"ExportData")==0)	
		string rwave, qwave, swave, ewave,wwave
		rwave="r"+rwavename[1,inf]
		swave="s"+rwavename[1,inf]
		qwave="q"+rwavename[1,inf]
		ewave="e"+rwavename[1,inf]
		wwave="w"+rwavename[1,inf]
	String theWaveList=qwave+";"+rwave
	wave swv=$qwave
	if (waveexists(swv))
		 theWaveList+= ";"+swave
	endif
	wave wwv=$wwave
	if (waveexists(wwv))
		 theWaveList+= ";"+wwave
	endif
	string filename=NewFileOutputName+".DAT"
	Save/J/O/B theWaveList as filename
	endif
	setDataFolder oldDF
end




Function DWS_ReflPopupProc(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum
	String popStr

	if (cmpstr(ctrlName,"Numcols")==0)
		NVAR num=root:Packages:ReflectivityTool:numcols
		num=popNum-1
	endif	
	if (cmpstr(ctrlName,"Ext")==0)
		NVAR ext=root:Packages:ReflectivityTool:Ext
		ext=popNum-1
	endif
end


Function DWS_ReflButtonProc(ctrlName) : ButtonControl
	String ctrlName
	SVAR BKGFolder=root:Packages:ReflectivityTool:DataFolderName2
	SVAR BKGIntensityWavename=root:Packages:ReflectivityTool:IntensityWaveName2
	SVAR BKGQWavename=root:Packages:ReflectivityTool:QWavename2
	SVAR basename=root:Packages:ReflectivityTool:basename
	SVAR FolderName=root:Packages:ReflectivityTool:DataFolderName
	SVAR RWaveName=root:Packages:ReflectivityTool:IntensityWaveName

	NVAR Data1_Background=root:Packages:ReflectivityTool:Data1_Background
	NVAR Data1_IntMultiplier=root:Packages:ReflectivityTool:Data1_IntMultiplier	
	NVAR Data1_Thickness=root:Packages:ReflectivityTool:Data1_Thickness	
	NVAR lambda=root:Packages:ReflectivityTool:refllambda
	NVAR csrAvg=root:Packages:ReflectivityTool:csravg
	NVAR GraphLogY=root:Packages:ReflectivityTool:GraphLogY
	NVAR GraphLogX=root:Packages:ReflectivityTool:GraphLogX
	NVAR SLDPro=root:Packages:ReflectivityTool:SLDPro
	NVAR THshift=root:Packages:ReflectivityTool:THshift
	string thefolder,thetext="",list,N,M,tracename
	variable counter = 0,NumberofWaves,background,start,step
	string wavenote, cmd,text,newname,savename,TheNote,swavename,wwavename,newfolder,qwavename
	
		if (datafolderexists(foldername))
			setdatafolder foldername
			qwavename="q"+rwavename[1,100]
	 		swavename="s"+rwavename[1,100]
			wwavename="w"+rwavename[1,100]
			wave RWave=$Rwavename	
			wave QWave=$Qwavename
			wave SWave=$Swavename
			wave WWave=$Wwavename
			SVAR basename=basename
		endif
		

		
	IF(cmpstr(ctrlName,"LoadCols")==0)
		NVAR num=root:Packages:ReflectivityTool:numcols
		NVAR ext=root:Packages:ReflectivityTool:ext
		if (num<1)
			Doalert 0, "Pick Colums and Extension"
		endif	
		switch(ext)	//load1d(newfolder,qdisplay,nm,nameline,headerlines,nocols,filetype,dialog)
				case 1:		
					load1d(1,2,2,10000,3,num,".txt",0)     //ORNL LR	
					abort
				case 2:		
					load1d(1,2,2,10000,0,num,".fit",0)    //Asterix Fits
					abort
				case 3:     
					load1d(1,2,2,10000,0,num,".dat",0)	//SPEAR		
		endswitch		
	endif
		
	IF(cmpstr(ctrlName,"FootPrintCorrect")==0)	//implemented by N. Hu
		setdatafolder GetWavesDataFolder(Qwave, 1 )
		Duplicate/o qwave,$(qwavename+"_fp")
		Duplicate/o rwave,$(rwavename+"_fp")
		
		variable r = 320 //distance
		variable slitsize = 0.03 //slit degree
		variable samplesize = 8 //sample in mm
	
		Wave savewave = $(rwavename+"_fp")
		savewave = rwave/min(samplesize/(r/(qwave*1.54/4/3.14)*sin(slitsize*3.14/180)),1)
		variable wave_max = Wavemax(savewave)
		savewave =savewave/wave_max
	endif

	if (cmpstr(ctrlName,"sqsw")==0)//takes sqrt of s and w waves
		if(datafolderexists(FolderName))
			setdatafolder FolderName
		else
			doalert 0, "Pick folder"
			abort
		endif
		Swave=swave^2
		wwave=wwave^2
		
	endif

	if (cmpstr(ctrlName,"Moto2qrsw")==0)//duplicates qrs to motofit format
		setdatafolder Foldername
		string LocalFoldername=GetDataFolder(0 )
		If (!DataFolderExists("root:MOTO") )
			Newdatafolder root:MOTO
		endif
		string newbasenm=ReplaceString("'", Localfoldername, "")
		newbasenm=Getnamechanges(newbasenm)
		string newfoldername="R"+newbasenm
		KillDataFolder /Z newfoldername
		Newdatafolder/o root:MOTO:$newfoldername
		string newqwavenm="q"+ newfoldername[1,100];string newrwavenm="r"+ newfoldername[1,100];string newswavenm="s"+ newfoldername[1,100];string newwwavenm="w"+ newfoldername[1,100]
		wave originaldata
		string oldqwavenm=localfoldername+"_q"
		wave oldqwave=$oldqwavenm
		variable nmpts=DimSize(originaldata, 0 )
		duplicate/o oldqwave, $newqwavenm, $newrwavenm,$newswavenm, $newwwavenm
		
		wave newqwave=$newqwavenm;wave newrwave=$newrwavenm;wave newswave=$newswavenm;wave newwwave=$newwwavenm
		
		 newqwave[p]=originaldata[p][0]; newrwave=originaldata[p][1]; newswave=originaldata[p][2]; newwwave=originaldata[p][3]
		
		//newswave=newswave*newrwave
		string destinationpath="root:MOTO:R"+newbasenm+":"
		setdatafolder $destinationpath
		//print getdatafolder(1)
		killwaves/z $newqwavenm,$newrwavenm,$newswavenm,$newwwavenm
		MoveWave newqwave, $destinationpath;MoveWave newrwave, $destinationpath;MoveWave newswave, $destinationpath;MoveWave newwwave, $destinationpath	
	endif

	if (cmpstr(ctrlName,"ChangeMotoNames")==0)//CHANGES ALL wave names containing the foldername
		if(datafolderexists(FolderName))
			setdatafolder FolderName
		else
			doalert 0, "Pick folder"
			abort
		endif
		
		string oldname=getdatafolder(0)
		newname=Getnamechanges(oldname)//user change name
		newname=CleanupName(newname, 0)
		IF (stringmatch(newname, ""))
			abort
		endif
		string wvlist=WaveList("*", ";", "")
		variable items=ItemsInList(wvlist)
		string wvnm,newwvnm
		variable i
		for(i=0;(i<items);i=i+1)	
			wvnm =stringfromlist (i,wvlist)
			newwvnm= ReplaceString(oldname, wvnm, newname)
			wave wv=$wvnm
			print newwvnm
			if (!waveexists($newwvnm))
				rename wv,$newwvnm
				//killwaves wv
			endif
		endfor		
			string fullfoldername="::"+oldname
			RenameDataFolder $fullfoldername,$newname
	endif
	
		if(cmpstr(ctrlName,"Deletept")==0)
		string DF=getdatafolder(1)		
		setdatafolder getwavesDataFolder(csrwaveref(A),1) 	
		Removepnt("ImportGraph")
		setdatafolder DF
	endif
	
	if ((cmpstr(ctrlName,"generrors")==0)|| (cmpstr(ctrlName," ErrorMult")==0))//makes dummy error wave
			DWS_Refl_Error_Gen()
	endif
	
	if (cmpstr(ctrlName,"qrs2moto")==0)//duplicates qrs to motofit format
		setdatafolder Foldername
		string LocFoldername=GetDataFolder(0 )
		If (!DataFolderExists("root:data") )
			Newdatafolder root:data
		endif
		LocFoldername=ReplaceString("'", LocFoldername, "")
		string newbasename=Getnamechanges(LocFoldername)
		newbasename=CleanupName(newbasename ,0 )
		Newdatafolder/o root:data:$newbasename
			
		variable n1=numpnts(qwave)
		//string newqwavename=newbasename+"_Q";string newrwavename=newbasename+"_R";string newswavename=newbasename+"_E";string newwwavename=newbasename+"_dq"
		setdatafolder root:data:$newbasename
		//duplicate/o qwave,$newqwavename;duplicate/o rwave,$newrwavename;duplicate/o swave,$newswavename
		
		make/o/N=(n1,4)/O originaldata
		originaldata[][0]=qwave[p]
		originaldata[][1]=rwave[p]
		originaldata[][2]=swave[p]
		if (Waveexists(Wwave))
			originaldata[][3]=Wwave[p]
			//duplicate/o wwave,$newwwavename
		else
			originaldata[][3]=1
		endif
		Redimension/D originaldata
		
	endif
	
	if (cmpstr(ctrlName,"Format")==0)

		SVAR 	ListOfGraphFormating=root:Packages:Irena:DWSplottingTool:ListOfGraphFormating
		ListOfGraphFormating=ReplaceStringByKey("Graph use colors",ListOfGraphFormating, num2str(1),"=")	
		IR2D_DWSInputPanelButtonProc("Format")
	endif
	
	if (cmpstr(ctrlName,"FlipProfile")==0)
		if ((SLDPro)&&(!waveexists(qwave)))
			Variable Offset= DimOffSet(Rwave,0)
			Variable Delta= -DimDelta (Rwave,0)
			Variable CursorX=xcsr(A)
			Variable NewOffset=CursorX-Offset
			//Print newoffset
			//SetScale/P x -104.47,0.949733,"",Rwave
			SetScale/P x NewOffset,Delta,"", RWave
		else
			string rwavenameflip=rwavename+"_flp"
			string qwavenameflip=qwavename+"_flp"
			duplicate/o rwave, $rwavenameflip;   duplicate/o qwave, $qwavenameflip
			wave rflip=$rwavenameflip;   wave qflip=$qwavenameflip
			qflip=-(qwave[p]-qwave[pcsr(A)])
			appendtograph rflip vs qflip
			RemoveFromGraph $rwavename
		endif
	endif
	
	
	IF(cmpstr(ctrlName,"Parratt")==0)
			IR2R_ReflectivitySimpleToolMain()
	endif
	

	
	IF(cmpstr(ctrlName,"AverageCursors")==0)	
		Wave w = CsrWaveRef(A)	
		if (!WaveExists(w))
			Doalert 0, "Cursor is not on graph"
			abort
		endif			
		WaveStats/q/r=[pcsr(A),pcsr(B)]w
		if(datafolderexists("root:Packages:ReflectivityTool"))
			setdatafolder root:Packages:ReflectivityTool
		endif
		make/o/N=2 xavedata,yavedata
		yavedata=V_avg
		 wave q = CsrXWaveRef(A  ,"ImportGraph")
		xavedata={ q(pcsr(A)), q[pcsr(B)]}
		appendtograph  yavedata vs xavedata
		ModifyGraph lsize(yavedata)=3,rgb(yavedata)=(0,0,0)
		text= "average ="+num2str (V_avg)	
		TextBox/C/N=text232/A=MT/X=2.00/Y=3.00 text	
		csravg=V_avg
		
	endif

	IF(cmpstr(ctrlName,"LoadParratt")==0)
			ImportParrattParameters()
	endif
	IF(cmpstr(ctrlName,"Normalize")==0)	
		WaveStats/r=[pcsr(A),pcsr(B)]rwave
		Text="average ="+num2str (V_avg)	
		//TextBox/C/N=text232/A=MT/X=2.00/Y=3.00 text	
		rwave/=V_avg
		swave/=V_avg
	endif
	IF(cmpstr(ctrlName,"rigaku")==0)
			 LoadRigakuDAT()
	endif
	

	
	IF(cmpstr(ctrlName,"rigakuASC")==0)
			loadRigakuASC()
	endif
	
	IF(cmpstr(ctrlName,"toq")==0)	
		qwave=(4*pi/lambda)*sin (qwave*pi/180)
	endif
	
	IF(cmpstr(ctrlName,"LoadUDF")==0)
			loadUDF_Panalytical(2,1)	
	endif
	
	IF(cmpstr(ctrlName,"Loadxrdml")==0)
			loadXRDml_Panalytical(2,1)	
	endif
	
	IF(cmpstr(ctrlName,"LoadASC")==0)
			load1d(1,2,4,-1,0,2,"",0)//(newfolder,qloadall,nm,nameline,headerlines,nocols,filetype)	
	endif
	
	
	IF(cmpstr(ctrlName,"RemoveReflTrace")==0)
		string tracelist=TraceNameList("ReflGraph", ";", 1 )
		 tracename=StringFromList(0, tracelist,";")
		If (!stringmatch(tracename, "" ))
			tracename=StringFromList(1, tracelist,";")
			RemoveFromGraph $tracename
		else
			Legend/K/N=text1
			string boxname="CF_"+Rwavename
			TextBox/K/N=$boxname
		endif
	endif	
		
	
	IF(cmpstr(ctrlName,"PlotReflData")==0)	
		setdatafolder  FolderName
		if ((SLDPro)&&(!waveexists(qwave)))
			Appendtograph/W=ReflGraph RWave
			cursor/P a,$rwavename,0
				Label Left "\f01\Z1810\S6\M\Z18 x SLD (\S-2\M\Z18)"
			Label bottom "\Z14Distance from SI ()"
			graphlogy	=0
			
		else
			Appendtograph/W=ReflGraph RWave vs qwave
			DWS_AttachErrorBars(1)
			doupdate
		
		
		TheNote=note(qwave)
		 ThShift=NumberByKey("ThShift", TheNote,"=")
		 if(!exists("Thshift"))
		 	Thshift=0
		 endif
		start=LocateValue(Rwavename, .9,1,2)
		cursor/P a,$rwavename,0
		cursor/P b,$rwavename,4
		csravg=vcsr(a)
		If (WaveExists(yavedata))
			Removefromgraph yavedata
		endif
		Legend/C/N=text1
	 	setaxis/A
			//SetAxis bottom 0.01,.15
			if(SLDPro)
				Label Left "\f01\Z1810\S6\M\Z18 x SLD (\S-2\M\Z18)"//doesn't work
				Label bottom "\Z14Distance from SI ()"
				graphlogy	=0
				cursor/P a,$rwavename,0
			else	
				Label Left "\Z14\f01\F'arial'Reflectivity"
				Label bottom "\\Z14\\f01\\F'Times New Roman'q(\\S-1\\M)"
				ModifyGraph log(left)=graphlogy	
				ModifyGraph log(bottom)=graphlogX	
			endif
			TextBox/K/N=FolderLegend	
		endif			

			FormatGraph(1)	
	endif
	
	
	IF(cmpstr(ctrlName,"RevertShift")==0)
		setdatafolder GetWavesDataFolder(Rwave, 1 )
		Savename=qwavename+"_org"
		wave savewave=$savename
		If(waveexists(savewave))
			qwave=savewave
			wave qangle
			 qangle=(180/pi)*asin(qwave*Lambda/(4*pi))
			start = (180/pi)*asin(qwave[0]*Lambda/(4*pi))	
			 step = ((180/pi)*asin(qwave[1]*Lambda/(4*pi)))-start
			SetScale/P x start,step,"", rwave;DelayUpdate	
			Thshift=0
				Note/K qwave, "Thshift= "+num2str(Thshift)+";"
		else
			Doalert 0,"No saved wave."
		endif	
	endif

	IF(cmpstr(ctrlName,"shiftTH")==0)//assumes x-scale is Th
		ShiftAngle()
	endif
	
	IF(cmpstr(ctrlName,"PlotvsAngle")==0)
		removefromgraph/Z $RwaveName
		 duplicate/o $qwavename, qangle
		 TheNote=note(qangle)
		 ThShift=NumberByKey("ThShift", TheNote,"=")
		  qangle=(180/pi)*asin(qwave*Lambda/(4*pi))
	 	appendtograph/W=ReflGraph Rwave vs qangle
	 	ModifyGraph log(left)=graphlogy	
		ModifyGraph log(bottom)=graphlogX	
		Label Left "\Z14\f01\F'Arial'Reflectivity"
				Label bottom "\\Z14\\f01\\F'Arial'Th"
	endif

end
